%% PSAP 2nd download
[psap2data, psap2info] = ARM_CDF_Import('E:\Google Drive\Projects\HI-SCALE SGP\Data\ARM_DATA\PSAP_matthewdownload');

psap2_badbits = [1,2,3,4];
for psap2bits_idx = 1:length(psap2_badbits)
	psap2data.Ba_R_Weiss(bitget(psap2data.qc_Ba_R_Weiss,ones(size(psap2data.qc_Ba_R_Weiss)).*psap2_badbits(psap2bits_idx)) == 1) = NaN;
	psap2data.Ba_G_Weiss(bitget(psap2data.qc_Ba_G_Weiss,ones(size(psap2data.qc_Ba_G_Weiss)).*psap2_badbits(psap2bits_idx)) == 1) = NaN;
	psap2data.Ba_B_Weiss(bitget(psap2data.qc_Ba_B_Weiss,ones(size(psap2data.qc_Ba_B_Weiss)).*psap2_badbits(psap2bits_idx)) == 1) = NaN;
	
end

psap2data.Ba_R_Weiss(psap2data.Ba_R_Weiss > 50) = NaN;
psap2data.Ba_G_Weiss(psap2data.Ba_G_Weiss > 50) = NaN;
psap2data.Ba_B_Weiss(psap2data.Ba_B_Weiss > 50) = NaN;

psap2data.Ba_R_Weiss(psap2data.Ba_R_Weiss < 0) = NaN;
psap2data.Ba_G_Weiss(psap2data.Ba_G_Weiss < 0) = NaN;
psap2data.Ba_B_Weiss(psap2data.Ba_B_Weiss < 0) = NaN;

psap_abssum_nancatch = psap2data.Ba_R_Weiss + psap2data.Ba_G_Weiss + psap2data.Ba_B_Weiss;

psap2data.Ba_R_Weiss(isnan(psap_abssum_nancatch)) = NaN;
psap2data.Ba_G_Weiss(isnan(psap_abssum_nancatch)) = NaN;
psap2data.Ba_B_Weiss(isnan(psap_abssum_nancatch)) = NaN;

[psap2data.avgtime, psap2data.avgr] = RollingAverage(psap2data.realtime,psap2data.Ba_R_Weiss,60);
[psap2data.avgtime, psap2data.avgg] = RollingAverage(psap2data.realtime,psap2data.Ba_G_Weiss,60);
[psap2data.avgtime, psap2data.avgb] = RollingAverage(psap2data.realtime,psap2data.Ba_B_Weiss,60);


psap2data.aae_rb = -log(psap2data.Ba_R_Weiss./psap2data.Ba_B_Weiss)./log(660./470);

[psap2data.avgtime, psap2data.avgaae] = RollingAverage(psap2data.realtime, psap2data.aae_rb,60);

